/*
 * Decompiled with CFR 0.152.
 */
package entities.creatures.enemies;

import core.states.GameState;
import entities.Entity;
import entities.creatures.EnemyCreatureEntity;
import entities.missiles.minion.MinionShotEntity;
import java.util.ArrayList;
import java.util.Random;
import util.Config;
import util.ResourceManager;

public class MinionEntity
extends EnemyCreatureEntity {
    private int minionKillMultiplier = 0;
    protected Random random;
    protected boolean superminion = false;
    protected boolean canShoot = true;
    protected boolean speedUp = true;

    public MinionEntity(GameState game, int x, int y) {
        super(game, "creatures/minion", x, y);
        this.setHitpoints(Config.get(Config.minionHitpoints));
        this.shotCooldown = Config.get(Config.minionShotCooldown);
    }

    @Override
    protected void set() {
        super.set();
        this.random = new Random();
        this.dx = -this.moveSpeed;
    }

    public void setCanShoot(boolean canShoot) {
        this.canShoot = canShoot;
    }

    public void setSpeedUp(boolean speedUp) {
        this.speedUp = speedUp;
    }

    public void notifyMinionkill() {
        ++this.minionKillMultiplier;
        this.refreshMoveSpeed();
    }

    @Override
    protected void refreshMoveSpeed() {
        this.moveSpeed = Math.min((Config.get(Config.minionMoveSpeed) + Config.get(Config.minionMoveSpeedPerLevel) * (double)this.game.getLevel()) * Math.pow(Config.get(Config.minionMovespeedUpPerMinionKill), this.minionKillMultiplier) * this.getMoveSpeedMultiplier(), (double)Config.get(Config.minionMoveSpeedCap));
        this.dx = this.dx < 0.0 ? -this.moveSpeed : this.moveSpeed;
    }

    public void makeSuperminion() {
        this.superminion = true;
        this.x -= 2.0;
        this.y += 2.0;
        this.setHitpoints(Config.get(Config.superminionHitpoints));
        this.shotCooldown = Config.get(Config.superminionShotCooldown);
        this.sprite = ResourceManager.get().getSprite("creatures/superminion");
    }

    @Override
    public void notifyDeath() {
        ArrayList<Entity> entities = this.game.getEntities();
        int i = 0;
        while (i < entities.size()) {
            Entity entity = entities.get(i);
            if (entity instanceof MinionEntity && this.speedUp) {
                ((MinionEntity)entity).notifyMinionkill();
            }
            ++i;
        }
        super.notifyDeath();
    }

    public boolean isSuperminion() {
        return this.superminion;
    }

    public void turnAround() {
        this.dx = -this.dx;
        this.y += (double)Config.get(Config.minionPxDownPerRowPassed);
    }

    @Override
    public void doLogic() {
        int chance;
        super.doLogic();
        if (this.isStunned()) {
            return;
        }
        if (this.dx < 0.0 && this.x <= 0.0 || this.dx > 0.0 && this.x >= ResourceManager.get().getDimension().getWidth() - (double)this.getW()) {
            ArrayList<Entity> entities = this.game.getEntities();
            int i = 0;
            while (i < entities.size()) {
                Entity entity = entities.get(i);
                if (entity instanceof MinionEntity) {
                    ((MinionEntity)entity).turnAround();
                }
                ++i;
            }
        }
        if (this.y > (double)(ResourceManager.get().getDimension().height - this.getH())) {
            this.game.playerDead();
        }
        if (this.game.isAttackDelayOver() && (chance = this.isSuperminion() ? this.random.nextInt(Config.get(Config.superminionShotChance) + (int)(Config.get(Config.superminionShotChancePerLevel) * (double)this.game.getLevel())) : this.random.nextInt(Config.get(Config.minionShotChance) + (int)(Config.get(Config.minionShotChancePerLevel) * (double)this.game.getLevel()))) > 100000) {
            this.useShot();
        }
    }

    @Override
    protected void shot() {
        if (!this.canShoot) {
            return;
        }
        MinionShotEntity shot = new MinionShotEntity(this, this.game, (int)this.x + this.getW() / 2 - 12, (int)this.y + this.getH() / 2);
        this.game.addEntity(shot);
    }

    @Override
    protected void abilityQ() {
    }

    @Override
    protected void abilityW() {
    }

    @Override
    protected void abilityE() {
    }

    @Override
    protected void abilityR() {
    }
}

